document.addEventListener('DOMContentLoaded', function() {
    // Плавное появление элементов при скролле
    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, {
        threshold: 0.1
    });

    // Анимация шагов
    const animatedElements = document.querySelectorAll('.guide-section, .step, .check-step');
    animatedElements.forEach(el => {
        el.style.opacity = '0';
        el.style.transform = 'translateY(20px)';
        el.style.transition = 'opacity 0.6s ease, transform 0.6s ease';
        observer.observe(el);
    });

    // интерактивность для таблицы
    const tableRows = document.querySelectorAll('.comparison-table tbody tr');
    tableRows.forEach(row => {
        row.addEventListener('mouseenter', function() {
            this.style.backgroundColor = '#f0f0f0';
        });
        
        row.addEventListener('mouseleave', function() {
            this.style.backgroundColor = '';
        });
    });

    // Копирование контактов
    const contacts = document.querySelectorAll('.contact-info li');
    contacts.forEach(contact => {
        contact.style.cursor = 'pointer';
        contact.addEventListener('click', function() {
            const text = this.textContent.replace(/^\s*\S+\s*:\s*/, '');
            navigator.clipboard.writeText(text).then(() => {
                const originalText = this.textContent;
                this.textContent = '✓ Скопировано!';
                setTimeout(() => {
                    this.textContent = originalText;
                }, 2000);
            });
        });
    });
});