document.addEventListener('DOMContentLoaded', function() {
    // Слайдер
    const slides = document.querySelector('.slides');
    const slideItems = document.querySelectorAll('.slide');
    const prevBtn = document.querySelector('.prev-btn');
    const nextBtn = document.querySelector('.next-btn');
    const indicatorsContainer = document.querySelector('.indicators');
    
    let currentSlide = 0;
    const totalSlides = slideItems.length;
    
    //  индикаторы
    for (let i = 0; i < totalSlides; i++) {
        const indicator = document.createElement('span');
        if (i === 0) indicator.classList.add('active');
        indicator.addEventListener('click', () => goToSlide(i));
        indicatorsContainer.appendChild(indicator);
    }
    
    const indicators = document.querySelectorAll('.indicators span');
    
    function updateSlider() {
        slides.style.transform = `translateX(-${currentSlide * 100}%)`;
        
        // Обновление индикаторов
        indicators.forEach((ind, index) => {
            ind.classList.toggle('active', index === currentSlide);
        });
    }
    
    function goToSlide(n) {
        currentSlide = n;
        if (currentSlide < 0) currentSlide = totalSlides - 1;
        if (currentSlide >= totalSlides) currentSlide = 0;
        updateSlider();
    }
    
    function nextSlide() {
        goToSlide(currentSlide + 1);
    }
    
    function prevSlide() {
        goToSlide(currentSlide - 1);
    }
    
    // События для кнопок
    nextBtn.addEventListener('click', nextSlide);
    prevBtn.addEventListener('click', prevSlide);
    
    // Автопрокрутка 
});
// Мобильное меню
const menuToggle = document.querySelector('.menu-toggle');
const nav = document.querySelector('.nav');

menuToggle.addEventListener('click', function() {
    nav.classList.toggle('active');
    menuToggle.classList.toggle('active');
});

//// Закрытие меню при клике на ссылку
const navLinks = document.querySelectorAll('.nav-list a');
navLinks.forEach(link => {
    link.addEventListener('click', () => {
        nav.classList.remove('active');
        menuToggle.classList.remove('active');
    });
});
/////// Инициализация Яндекс.Карты
function initMap() {
    // Создаем карту
    ymaps.ready(function() {
        var map = new ymaps.Map('map', {
            center: [55.76, 37.64], 
            zoom: 10
        });

/// Масщтаб
        if (dealers.length > 1) {
            map.setBounds(map.geoObjects.getBounds());
        }
    });
}

// Вызов карты
initMap();